% S-Function demonstrating how to load the Phidget library as well as creating, opening(remotely) and attaching to the Phidget
function [sys,x0,str,ts] = PhidgetInterfaceKit_RemoteIP(t,x,u,flag, serial,addr,p,pw)

switch flag,

  %%%%%%%%%%%%%%%%%%
  % Initialization %
  %%%%%%%%%%%%%%%%%%
  case 0,
   [sys,x0,str,ts]=mdlInitializeSizes(serial, addr,p,pw);
  
  %%%%%%%%%%  
  % Update %
  %%%%%%%%%%
  case 2,                                               
    sys = mdlUpdate(t,x,u);
    
  %%%%%%%%%%
  % Output %
  %%%%%%%%%%
  case 3,                                               
    sys = mdlOutputs(t,x,u);    
    
  %%%%%%%%%%%%%
  % Terminate %
  %%%%%%%%%%%%%
  case 9,
    sys=mdlTerminate(t,x,u);

  otherwise
    error(['unhandled flag = ',num2str(flag)]);
end

%end sfundsc1

%
%=============================================================================
% mdlInitializeSizes
% Return the sizes, initial conditions, and sample times for the S-function.
%=============================================================================
%
function [sys,x0,str,ts]=mdlInitializeSizes(serial, addr,p,pw)

if ~libisloaded('phidget21')
    loadlibrary('phidget21', 'phidget21Matlab.h');
end

ptr = libpointer('int32Ptr',0);
calllib('phidget21', 'CPhidgetInterfaceKit_create', ptr);

global handle;
handle = get(ptr, 'Value');

calllib('phidget21', 'CPhidget_openRemoteIP', handle, serial, addr,p,pw);

%application takes the next 2500ms to attach to the Phidget
if calllib('phidget21', 'CPhidget_waitForAttachment', handle, 2500) == 0
    disp('Opened InterfaceKit')
else
    disp('Could not open InterfaceKit')
end


sizes = simsizes;

sizes.NumContStates  = 0;
sizes.NumDiscStates  = 0;  
sizes.NumOutputs     = 0;
sizes.NumInputs      = 0;
sizes.DirFeedthrough = 0;
sizes.NumSampleTimes = 1;

sys = simsizes(sizes);
x0  = [];
str = [];
ts = [-1 0];
% end mdlInitializeSizes

%
%=======================================================================
% mdlUpdate
% Handle discrete state updates, sample time hits, and major time step
% requirements.
%=======================================================================
%
function sys = mdlUpdate(t,x,u)
sys = [];
%end mdlUpdate

%
%=======================================================================
% mdlOutputs
% Return the output vector for the S-function
%=======================================================================
%
function sys = mdlOutputs(t,x,u)
sys = [];

%end mdlOutputs

%
%=============================================================================
% mdlTerminate
% Perform any end of simulation tasks.
%=============================================================================
%
function sys=mdlTerminate(t,x,u)
global handle;

% clean up
calllib('phidget21', 'CPhidget_close', handle);
calllib('phidget21', 'CPhidget_delete', handle);

sys = [];

% end mdlTerminate


